new const NINTENDOMOD_LUIGI_PLUGIN[] = "Nintendo Mod X Luigi"
new const NINTENDOMOD_LUIGI_VERSION[] = "2.2.1"
new const NINTENDOMOD_LUIGI_AUTHOR[] = "Soloist/Mephisto"

/*
	1st Passive: Silent Walking
		* Footsteps are silent.
	2nd Passive: Invisibility
		* You become harder to see.
	Skill 1: Fire Uppercut
		* On deadly knife attack the enemy is launched upwards and backwards.
	Skill 2: Long Jump
		* Press duck+jump you will be launched forward.
	Skill 3: Speed
		* Runs Faster.
	PowerUp: Vacuum
		* Vacuum the enemies weapon (Make enemy drop their weapons).

	Based on Soloist's original source code Luigi v1.1, updated by Mephisto
	Version 2.2.1
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 2.2.1
			* plugin title changed
		Version 2.2
			* fixed freeze-time rush
		Version 2.1
			* increased additional invisibility fade time after knife attack
			* reduced fireuppercut's extra damage when stabbed with left mouse button
			* removed easy longjump bhopping
			* modified longjump height depending on skill lvl
			* fixed longjump (because Valve removed "item_longjump")
		Version 2.0.1
			* lvl 1 PowerUp fixed
		Version 2.0
			* PowerUp vacuums all players' weapons around target player, knockbacks them (at lvl 2) and flashs a little (at lvl 3)
			* skills have four levels now, PowerUp has three levels
			* lvl cap increased to 15
			* 2nd passive skill added
		Version 1.2
			* Fixed Fire Uppercut bug
		Version 1.1
			* Fixed speed bug
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <cstrike>
#include <fun>
#include <fakemeta>
#include <nintendomod>

new const LUIGI_FOOTSTEPSOUND[11] = {100, 105, 110, 115, 120, 125, 150, 175, 200, 225, 999};
new const LUIGI_INVISIBILITY[5] = {50, 45, 40, 35, 30};
new const Float:LUIGI_INVISFADENUM[5] = {26.0, 24.0, 22.0, 20.0, 18.0};
new const LUIGI_FIREUPPERCUTDMG[4] = {20, 35, 50, 150};
new const LUIGI_LONGJUMP[4] = {500, 550, 600, 625};
new const Float:LUIGI_LONGJUMPHEIGHT[4] = {268.0, 270.0, 272.0, 275.0};
new const Float:LUIGI_FIREUPPERCUTPROB[4] = {0.333, 0.666, 0.75, 0.80};
new const Float:LUIGI_SPEEDNUM[4] = {300.0, 325.0, 350.0, 365.0};
new const Float:LUIGI_VACKNOCKBACK[2] = {230.0, 250.0};

new charName[] = "Luigi";
new passiveName[] = "Silent Walking";
new passive2Name[] = "Invisibility";
new skill1Name[] = "Fire Uppercut";
new skill2Name[] = "Long Jump";
new skill3Name[] = "Speed";
new powerupName[] = "Vacuum";
new initName[] = "Luigi_Init";
new keyDownName[] = "Luigi_Vacuum";

new passiveHelp[] = "Footsteps are silent.";
new passive2Help[] = "You become harder to see."
new skill1Help[] = "On deadly knife attack the enemy is launched upwards and backwards.";
new skill2Help[] = "Press duck+jump you will be lauched forward.";
new skill3Help[] = "Runs Faster.";
new powerupHelp[] = "Vacuum the enemies weapon (Make enemy drop their weapons).";

new PlayerLevel[33];
new PlayerSkill1[33];
new PlayerSkill2[33];
new PlayerSkill3[33];
new PlayerPowerUp[33];

new bool:BetweenRounds;

new Float:FadeTimer[33], Fading[33];
new bool:longjump[33];

new fireUpperCut;

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") == -1)
	{
		server_print("**********************************");
		server_print("*** Nintendo Mod is not loaded ***");
		server_print("**********************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_LUIGI_PLUGIN, NINTENDOMOD_LUIGI_VERSION, NINTENDOMOD_LUIGI_AUTHOR);

	register_cvar("NintendoMod_Luigi_Version", NINTENDOMOD_LUIGI_VERSION, FCVAR_SERVER|FCVAR_SPONLY);

	register_event("ResetHUD", "ResetHUD", "b");
	register_logevent("RoundStart", 2, "1=Round_Start");
	register_logevent("RoundEnd", 2, "1=Round_End");

	register_forward(FM_PlayerPreThink, "Luigi_PreThink");

	register_event("Damage", "Luigi_FireUpperCut", "b", "2!0");
	register_event("CurWeapon", "Luigi_Speed", "be");

	Nintendo_RegisterChar(charName, passiveName, passive2Name, skill1Name, skill2Name, skill3Name, powerupName, initName);
	Nintendo_RegisterHelp(charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp);
	Nintendo_RegisterKeyDown(charName, keyDownName);

	register_srvcmd(initName, initName);
	register_srvcmd(keyDownName, keyDownName);
}

public plugin_precache()
{
	fireUpperCut = engfunc(EngFunc_PrecacheModel, "sprites/nintendomod/luigi_flame.spr");
	engfunc(EngFunc_PrecacheSound, "nintendomod/luigi_invis.wav");
}

public client_connect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);

	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);
	remove_task(id);

	return PLUGIN_CONTINUE;
}

public InitPlayer(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id] = 0;
	PlayerSkill1[id] = 0;
	PlayerSkill2[id] = 0;
	PlayerSkill3[id] = 0;
	PlayerPowerUp[id] = 0;

	return PLUGIN_CONTINUE;
}

public Luigi_Init()
{
	new temp[33];
	read_argv(1, temp, 32);
	new id = str_to_num(temp);

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	read_argv(2, temp, 32);
	new index  = str_to_num(temp);

	if(index == 0)
	{
		read_argv(3, temp, 32);
		new level = str_to_num(temp);
		read_argv(4, temp, 32);
		new skill1 = str_to_num(temp);
		read_argv(5, temp, 32);
		new skill2 = str_to_num(temp);
		read_argv(6, temp, 32);
		new skill3 = str_to_num(temp);
		read_argv(7, temp, 32);
		new powerup = str_to_num(temp);

		PlayerLevel[id] = level;
		PlayerSkill1[id] = skill1;
		PlayerSkill2[id] = skill2;
		PlayerSkill3[id] = skill3;
		PlayerPowerUp[id] = powerup;
	}
	else
	{
		read_argv(3, temp, 32);
		new value = str_to_num(temp);

		switch(index)
		{
			case 1: PlayerLevel[id] = value;
			case 2: PlayerSkill1[id] = value;
			case 3: PlayerSkill2[id] = value;
			case 4: PlayerSkill3[id] = value;
			case 5: PlayerPowerUp[id] = value;
		}
	}

	ResetHUD(id);

	return PLUGIN_CONTINUE;
}

public RoundStart()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = false;

	return PLUGIN_CONTINUE;
}

public RoundEnd()
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	BetweenRounds = true;

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	remove_task(id);
	Fading[id] = 0;
	FadeTimer[id] = 0.0;
	Nintendo_SetGlow(id);

	set_task(get_cvar_float("mp_freezetime"), "Luigi_Speed", id);

	return PLUGIN_CONTINUE;
}

public Luigi_PreThink(id) // 1st Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	// Luigi Silent Walking (1st Passive)
	if(PlayerLevel[id] > 10)
		set_pev(id, pev_flTimeStepSound, LUIGI_FOOTSTEPSOUND[10]);
	else
		set_pev(id, pev_flTimeStepSound, LUIGI_FOOTSTEPSOUND[PlayerLevel[id]]);

	// Luigi Longjump (Skill 2)
	if(PlayerSkill2[id] > 0)
		Luigi_LongJump(id);

	return PLUGIN_CONTINUE;
}

public Luigi_FireUpperCut(id) // Skill 1
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart)
	new headshot = bodypart == 1 ? 1 : 0
	new damage = read_data(2);

	if(!Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(weapon == CSW_KNIFE)
	{
		if(PlayerLevel[attacker] > 10)
		{
			if(Fading[attacker])
			{
				if(Fading[attacker] == -1)
				{
					Fading[attacker] = 1;
					set_task(1.0, "Luigi_Invisibility", attacker);
					Nintendo_StatusHUD(id, "You are becoming invisible...", 1);
				}
				FadeTimer[attacker] += LUIGI_INVISFADENUM[PlayerLevel[attacker] - 11] / 2;
				if(FadeTimer[attacker] > LUIGI_INVISFADENUM[PlayerLevel[attacker] - 11])
					FadeTimer[attacker] = LUIGI_INVISFADENUM[PlayerLevel[attacker] - 11];

				Luigi_SetInvisibility(attacker);
			}
		}
		if(PlayerSkill1[attacker] > 0)
		{
			if(Nintendo_TeamKill(id, attacker))
			{
				new Float:randomnumber = random_float(0.0, 1.0);
				if(randomnumber <= LUIGI_FIREUPPERCUTPROB[PlayerSkill1[attacker] - 1])
				{
					new idOrigin[3], vicOrigin[3], distance;

					idOrigin = Nintendo_GetOrigin(attacker);
					vicOrigin = Nintendo_GetOrigin(id);
					distance = get_distance(idOrigin, vicOrigin);

					new param[4];
					param[0] = id;
					param[1] = (vicOrigin[0] - idOrigin[0] / distance) * 300;
					param[2] = (vicOrigin[1] - idOrigin[1] / distance) * 300;
					param[3] = 200;

					new Float:tmp1[3], Float:tmp2[3];
					tmp1[0] = 0.0; tmp1[1] = 0.0; tmp1[2] = 0.0;
					tmp2[0] = 0.0; tmp2[1] = 0.0; tmp2[2] = 200.0;

					Nintendo_SetVelocity(id, tmp1);
					Nintendo_SetVelocity(id, tmp2);

					set_task(0.1, "Luigi_PushBack", 0, param, 4);

					Luigi_FireUpperCutSprite(id, attacker);
					// stabbed with right mouse button (stronger)
					if(damage > 50)
						Nintendo_ExtraDamage(attacker, id, LUIGI_FIREUPPERCUTDMG[PlayerSkill1[attacker] - 1], "Fire Uppercut", headshot);
					// stabbed with left mouse button (reduced extra damage)
					else
						Nintendo_ExtraDamage(attacker, id, LUIGI_FIREUPPERCUTDMG[PlayerSkill1[attacker] - 1]/4, "Fire Uppercut", headshot);
				}
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Luigi_PushBack(param[])
{
	new id, Float:velocity[3];

	id = param[0];
	velocity[0] = float(param[1]);
	velocity[1] = float(param[2]);
	velocity[2] = float(param[3]);

	Nintendo_SetVelocity(id, velocity);
}

public Luigi_FireUpperCutSprite(victim, attacker) // Skill 1
{
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_BEAMENTS)
	write_short(attacker);
	write_short(victim);
	write_short(fireUpperCut);
	write_byte(0);
	write_byte(15);
	write_byte(10);
	write_byte(80);
	write_byte(10);
	write_byte(255);
	write_byte(0);
	write_byte(0);
	write_byte(255);
	write_byte(0);
	message_end();

	new origin[3]
	pev(victim, pev_origin, origin)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_ELIGHT);
	write_short(victim);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]);
	write_coord(100);
	write_byte(255);
	write_byte(0);
	write_byte(0);
	write_byte(15);
	write_coord(0);
	message_end();
}

public Luigi_LongJump(id) // Skill 2
{
	new Float:velocity[3];
	new newButton = pev(id, pev_button);
	pev(id, pev_velocity, velocity);

	if(longjump[id])
	{
		if(pev(id, pev_flags) & FL_ONGROUND && newButton & IN_DUCK && newButton & IN_JUMP)
			if(abs(floatround(velocity[0])) + abs(floatround(velocity[1])) > 5)
			{
				new Float:NewVelocity[3];
				velocity_by_aim(id, LUIGI_LONGJUMP[PlayerSkill2[id]-1], NewVelocity);
				NewVelocity[2] = LUIGI_LONGJUMPHEIGHT[PlayerSkill2[id]-1];
				set_pev(id, pev_velocity, NewVelocity);
				longjump[id] = false;
			}
	}
	else if(pev(id, pev_flags) & FL_ONGROUND)
	{
		if(!(newButton & IN_DUCK) && !(newButton & IN_JUMP))
			longjump[id] = true;
	}

	return PLUGIN_CONTINUE;
}

public Luigi_Speed(id) // Skill 3 & 2nd Passive
{
	new invis_state[60];
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id) || BetweenRounds)
		return PLUGIN_HANDLED;

	if(PlayerSkill3[id] > 0)
		Nintendo_SetSpeed(id, LUIGI_SPEEDNUM[PlayerSkill3[id]-1]);

	if(PlayerLevel[id] > 10)
	{
		new clip, ammo, weapon;
		weapon = get_user_weapon(id, clip, ammo);
		if(weapon == CSW_KNIFE && !Fading[id])
		{
			Fading[id] = 1;
			if(task_exists(id))
				remove_task(id);
			set_task(1.0, "Luigi_Invisibility", id);
			Nintendo_StatusHUD(id, "You are becoming invisible...", 1);
		}
		else if(weapon != CSW_KNIFE && Fading[id])
		{
			Fading[id] = 0;
			FadeTimer[id] = 0.0;
			Nintendo_SetGlow(id);
			format(invis_state, 60, "Invisibility: none");
			set_hudmessage(255, 255, 255, -1.0, 0.05, 0, 6.0, 2.0, 0.1, 0.1, 4)
			show_hudmessage(id, invis_state);
		}
	}

	return PLUGIN_CONTINUE;
}

public Luigi_Invisibility(id) // 2nd Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(!Fading[id] || Fading[id] == -1)
		return PLUGIN_CONTINUE;

	if(!Nintendo_IsValidPlayer(id,true))
	{
		Fading[id] = 0;
		FadeTimer[id] = 0.0;
		return PLUGIN_CONTINUE;
	}

	FadeTimer[id] += 1.0;
	Luigi_SetInvisibility(id);

	if(Fading[id] == 1)
		set_task(1.0, "Luigi_Invisibility", id);

	return PLUGIN_CONTINUE;
}

public Luigi_SetInvisibility(id)
{
	new invis_state[60];
	new Float:percentage = FadeTimer[id] / LUIGI_INVISFADENUM[PlayerLevel[id] - 11];
	if(percentage >= 1.0)
	{
		percentage = 1.0;
		Fading[id] = -1;
		FadeTimer[id] = 0.0;
		Nintendo_StatusHUD(id, "You reached max. invisibility", 1);
		emit_sound(id, CHAN_AUTO, "nintendomod/luigi_invis.wav", 0.2, ATTN_NORM, 0, PITCH_NORM);
		format(invis_state, 60, "Invisibility: max. %d %s", floatround(100.0*float(LUIGI_INVISIBILITY[PlayerLevel[id] - 11])/255.0), "%%");
		set_hudmessage(255, 255, 255, -1.0, 0.05, 0, 6.0, 2.0, 0.1, 0.1, 4)
		show_hudmessage(id, invis_state);
	}

	new diff = floatround(percentage * float(255 - LUIGI_INVISIBILITY[PlayerLevel[id] - 11]));
	new amount = 255 - diff;
	set_user_rendering(id, kRenderFxNone, 0, 0, 0, kRenderTransTexture, amount);

	if(percentage < 1.0)
	{
		new fade_state = floatround(100.0*float(amount)/255.0);
		new timeleft = floatround(LUIGI_INVISFADENUM[PlayerLevel[id] - 11] - FadeTimer[id]);
		new maxfade = floatround(100.0*float(LUIGI_INVISIBILITY[PlayerLevel[id] - 11]) / 255.0);
		format(invis_state, 60, "Invisibility: fading... %d %s - %d sec to max. %d %s", fade_state, "%%", timeleft, maxfade, "%%");
		set_hudmessage(255, 255, 255, -1.0, 0.05, 0, 6.0, 2.0, 0.1, 0.1, 4)
		show_hudmessage(id, invis_state);
	}

	return PLUGIN_CONTINUE;
}

public Luigi_Vacuum()
{
	new temp[6]
	read_argv(1, temp, 5)
	new id = str_to_num(temp)
	new idOrigin[3], vicOrigin[3], luigiOrigin[3];

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerPowerUp[id] >= 1)
	{
		new victim, body;
		get_user_aiming(id, victim, body);
		get_user_origin(id, luigiOrigin);

		if(Nintendo_IsValidPlayer(victim) && (body==2 || body==4))
		{
			if(Nintendo_TeamKill(id, victim))
			{
				get_user_origin(victim, idOrigin);
				Nintendo_PowerUpUsed(id, 1, 30);
				new players[32], num, player;
				get_players(players, num);

				for(new i = 0; i < num; i++)
				{
					if(PlayerPowerUp[id] > 1)
						player = players[i];
					else
						player = victim;
					if(get_user_team(id) == get_user_team(player))
						continue;
					if(Nintendo_IsValidPlayer(player))
					{
						get_user_origin(player, vicOrigin);
						if(get_distance(vicOrigin, idOrigin) < 500.0)
						{
							new weapons[32], wpnnum, weapname[24];
							get_user_weapons(player, weapons, wpnnum);

							for(new i = 0; i < wpnnum; i++)
							{
								if(weapons[i] == CSW_C4 || weapons[i] == CSW_KNIFE || weapons[i] == CSW_HEGRENADE || weapons[i] == CSW_SMOKEGRENADE || weapons[i] == CSW_FLASHBANG)
									continue;

								get_weaponname(weapons[i], weapname, 23);
								engclient_cmd(player, "drop", weapname);
							}

							if(PlayerPowerUp[id] >= 2)
							{
								new Float:velocity[3];
								velocity[0] = float((vicOrigin[0] - luigiOrigin[0])) / 3.0;
								velocity[1] = float((vicOrigin[1] - luigiOrigin[1])) / 3.0;
								velocity[2] = LUIGI_VACKNOCKBACK[PlayerPowerUp[id] - 2];
								set_pev(player, pev_velocity, velocity);
							}

							engclient_cmd(victim, "weapon_knife");

							new name[33], tmp[54];
							get_user_name(id, name, 32);
							format(tmp, 53, "[Luigi] %s vacuumed your weapons", name);
							Nintendo_StatusHUD(player, tmp, 1);
							if(PlayerPowerUp[id] >= 3)
								Nintendo_ScreenFade(player, (1<<15), (1<<10), (1<<12), 255, 255, 255, 210);
						}
					}
					if(PlayerPowerUp[id] == 1)
						return PLUGIN_CONTINUE;
				}
			}
		}
		else
			Nintendo_PowerUpDeny(id, "Not a valid target.");
	}

	return PLUGIN_CONTINUE;
}
